import vtk.vtkFloatArray;
import vtk.vtkPoints;
import vtk.vtkPolyData;
import vtk.vtkProgrammableFilter;

public class Test7 extends vtkProgrammableFilter {
	vtkPoints outputPoints;

	public Test7() {
		SetExecuteMethod(this, "compute");
	}

	public void modify(int p_ptId) {
		System.out.println("modify " + p_ptId);
		// System.out.println("modify nb " + outputPoints.GetNumberOfPoints());
		outputPoints.SetPoint(p_ptId, 0, 0, 2);
		Modified();
	}

	public void compute() {
		System.out.println("compute "
				+ (GetPolyDataInput().GetMTime() > GetMTime()));
		vtkPolyData polyDataInput = GetPolyDataInput();
		vtkPolyData polyDataOutput = GetPolyDataOutput();
		polyDataOutput.CopyStructure(polyDataInput);
		polyDataOutput.GetPointData().PassData(polyDataInput.GetPointData());
		polyDataOutput.GetCellData().PassData(polyDataInput.GetCellData());
		vtkPoints inputPoints = polyDataInput.GetPoints();
		polyDataOutput.SetPoints(outputPoints);

		if (outputPoints == null || GetPolyDataInput().GetMTime() > GetMTime()) {
			outputPoints = new vtkPoints();
			outputPoints.SetNumberOfPoints(inputPoints.GetNumberOfPoints());
			polyDataOutput.SetPoints(outputPoints);
			//
			for (int i = 0; i < inputPoints.GetNumberOfPoints(); i++) {
				outputPoints.SetPoint(i, inputPoints.GetPoint(i)[0],
						inputPoints.GetPoint(i)[1], inputPoints.GetPoint(i)[2]);
			}
		}
	}
}